// MORSE CODE RADIO
// by Thom Hines
// http://thomhines.com



// MORSE CODE INTERPRETER BUILT BY SILVEIRA NETO
// http://silveiraneto.net/2009/02/28/morse-code-translator-with-arduino/

int led = 13;                   // LED connected to digital pin 13
int buzzer = 11;                // buzzer connected to digital pin 12
int dial = 14;
int unit = 10;                  // duration of a pulse
int val = 0;
 
char * morsecode[] = {
    "-----",  // 0
    ".----",  // 1
    "..---",  // 2
    "...--",  // 3
    "....-",  // 4
    ".....",  // 5
    "-....",  // 6 
    "--...",  // 7
    "---..",  // 8
    "----.",  // 9
    "---...", // :
    "-.-.-.", // ;
    "",       // < (there's no morse for this simbol)
    "-...-",  // =
    "",       // > (there's no morse for this simbol)
    "..--..", // ?
    ".--._.", // @
    ".-",     // A
    "-...",   // B
    "-.-.",   // C
    "-..",    // D
    ".",      // E
    "..-.",   // F
    "--.",    // G
    "....",   // H
    "..",     // I
    ".---",   // J
    "-.-",    // K
    ".-..",   // L
    "--",     // M
    "-.",     // N
    "---",    // O
    ".--.",   // P
    "--.-",   // Q
    ".-.",    // R
    "...",    // S
    "-",      // T
    "..-",    // U
    "...-",   // V
    ".--",    // W
    "-..-",   // X
    "-.--",   // Y
    "--.."    // Z
};
 
void setup() {
  pinMode(led, OUTPUT);
  pinMode(buzzer, OUTPUT);
  Serial.begin(9600);
}
 
void say_morse_word(char * msg){
  int index = 0;
  while(msg[index]!='\0'){
    // say a dash
    if(msg[index]=='-'){
      dash();
    }
    // say a dot
    if(msg[index]=='.'){
      dot();
    }
    // gap beetween simbols
    intragap();
    index++;
  }
}
 
// beep
void beep(int time){
  int i;
  int t = 100; // period of the wav. bigger means lower pitch.
  int beepduration = (int)((float)time/t*1800);
  digitalWrite(led, HIGH);
  for(i=0;i<beepduration;i++){
    digitalWrite(buzzer, HIGH);
    delayMicroseconds(t);
    digitalWrite(buzzer, LOW);
    delayMicroseconds(t);
  }
  delay(time);
}
 
// silence
void silence(int time){
  digitalWrite(led, LOW);
  delay(time);
}
 
// general procedure for .
void dot() {
  beep(unit);
  Serial.print(".");
}
 
// general procedure for -
void dash() {
  beep(unit*3);
  Serial.print(".");
}
 
// gap between dots and dashes
void intragap() {
  silence(unit);
  Serial.print("_");
}
 
// gap between letters
void shortgap() {
  silence(3*unit);
  Serial.print("__");
}
 
// gap be  tween words
void mediumgap() {
  silence(7*unit);
  Serial.print("_ _");
}
 
void say_char(char letter){
  if((letter>='0')&&(letter<='Z')&&(letter!='<')&&(letter!='>')){
    Serial.print(morsecode[letter-'0']);
    Serial.println('morse: ');
    say_morse_word(morsecode[letter-'0']);
    shortgap();
  } else {
    if(letter==' '){
      Serial.print(" \\ ");
      mediumgap();
    }else{
      Serial.print("X");
    }
  }
}
 
void loop(){
  val = analogRead(dial);
  Serial.println(val);
  if(val > 1015) say_string("HELP I NEED SOMEBODY HELP NOT JUST ANYBODY HELP YOU KNOW I NEED SOMEONE HELP WHEN I WAS YOUNGER SO MUCH YOUNGER THAN TODAY I NEVER NEEDED ANYBODYS HELP IN ANY WAY BUT NOW THESE DAYS ARE GONE IM NOT SO SELF ASSURED NOW I FIND IVE CHANGED MY MIND AND OPENED UP THE DOORS HELP ME IF YOU CAN IM FEELING DOWN AND I DO APPRECIATE YOU BEING ROUND HELP ME GET MY FEET BACK ON THE GROUND WONT YOU PLEASE PLEASE HELP ME? AND NOW MY LIFE HAS CHANGED IN OH SO MANY WAYS MY INDEPENDENCE SEEMS TO VANISH IN THE HAZE BUT EVERY NOW AND THEN I FEEL SO INSECURE I KNOW THAT I JUST NEED YOU LIKE IVE NEVER DONE BEFORE HELP ME IF YOU CAN IM FEELING DOWN AND I DO APPRECIATE YOU BEING ROUND HELP ME GET MY FEET BACK ON THE GROUND WONT YOU PLEASE PLEASE HELP ME WHEN I WAS YOUNGER SO MUCH YOUNGER THAN TODAY I NEVER NEEDED ANYBODYS HELP IN ANY WAY BUT NOW THESE DAYS ARE GONE IM NOT SO SELF ASSURED NOW I FIND IVE CHANGED MY MIND AND OPENED UP THE DOORS HELP ME IF YOU CAN IM FEELING DOWN AND I DO APPRECIATE YOU BEING ROUND HELP ME GET MY FEET BACK ON THE GROUND WONT YOU PLEASE PLEASE HELP ME HELP ME HELP ME OH");
  
  // the following lines were intended to work
  // with the combo power/volume dial on
  // the radio. Unfortunately, when hooked
  // up how I soldered the dial, it immediately
  // caused a short. :(
  //if(val > 10 && val <= 50) say_string("HELP I NEED SOMEBODY HELP NOT JUST ANYBODY HELP YOU KNOW I NEED SOMEONE HELP WHEN I WAS YOUNGER SO MUCH YOUNGER THAN TODAY I NEVER NEEDED ANYBODYS HELP IN ANY WAY BUT NOW THESE DAYS ARE GONE IM NOT SO SELF ASSURED NOW I FIND IVE CHANGED MY MIND AND OPENED UP THE DOORS HELP ME IF YOU CAN IM FEELING DOWN AND I DO APPRECIATE YOU BEING ROUND HELP ME GET MY FEET BACK ON THE GROUND WONT YOU PLEASE PLEASE HELP ME? AND NOW MY LIFE HAS CHANGED IN OH SO MANY WAYS MY INDEPENDENCE SEEMS TO VANISH IN THE HAZE BUT EVERY NOW AND THEN I FEEL SO INSECURE I KNOW THAT I JUST NEED YOU LIKE IVE NEVER DONE BEFORE HELP ME IF YOU CAN IM FEELING DOWN AND I DO APPRECIATE YOU BEING ROUND HELP ME GET MY FEET BACK ON THE GROUND WONT YOU PLEASE PLEASE HELP ME WHEN I WAS YOUNGER SO MUCH YOUNGER THAN TODAY I NEVER NEEDED ANYBODYS HELP IN ANY WAY BUT NOW THESE DAYS ARE GONE IM NOT SO SELF ASSURED NOW I FIND IVE CHANGED MY MIND AND OPENED UP THE DOORS HELP ME IF YOU CAN IM FEELING DOWN AND I DO APPRECIATE YOU BEING ROUND HELP ME GET MY FEET BACK ON THE GROUND WONT YOU PLEASE PLEASE HELP ME HELP ME HELP ME OH");
  //else if(val > 50 && val <= 100) say_string("YOURE NOT SHY YOU GET AROUND YOU WANNA FLY DONT WANT YOUR FEET ON THE GROUND YOU STAY UP YOU WONT COME DOWN YOU WANNA LIVE YOU WANNA MOVE TO THE SOUND GOT FIRE IN YOUR VEINS BURNIN HOT BUT YOU DONT FEEL THE PAIN YOUR DESIRE IS INSANE YOU CANT STOP UNTIL YOU DO IT AGAIN BUT SOMETIMES I WONDER AS I LOOK IN YOUR EYES THAT MAYBE YOURE THINKING OF SOME OTHER GUY BUT I KNOW YES I KNOW HOW TO TREAT YOU RIGHT THATS WHY YOU CALL ME IN THE MIDDLE OF THE NIGHT  YOU SAY ITS URGENT SO URGENT SO-OH-OH URGENT JUST YOU WAIT AND SEE HOW URGENT MY LOVE CAN BE ITS URGENT  YOU PLAY TRICKS ON MY MIND YOURE EVERYWHERE BUT YOURE SO HARD TO FIND YOURE NOT WARM OR SENTIMENTAL YOURE SO EXTREME YOU CAN BE SO TEMPERAMENTAL BUT IM NOT LOOKING FOR A LOVE THAT WILL LAST I KNOW WHAT I NEED AND I NEED IT FAST YEAH THERES ONE THING IN COMMON THAT WE BOTH SHARE THATS A NEED FOR FOR EACH OTHER ANYTIME ANYWHERE  IT GETS SO URGENT SO URGENT YOU KNOW ITS URGENT I WANNA TELL YOU ITS THE SAME FOR ME OOH-OOOH SO-OH-OH URGENT JUST YOU WAIT AND SEE HOW URGENT OUR LOVE CAN BE ITS URGENT  YOU SAY ITS URGENT MAKE IT FAST MAKE IT URGENT DO IT QUICK DO IT URGENT GOTTA RUSH MAKE IT URGENT WANT IT QUICK URGENT URGENT EMERGENCY URGENT URGENT EMERGENCY URGENT URGENT URGENT URGENT EMERGENCY URGENT URGENT URGENT URGENT EMERGENCY SO URGENT EMERGENCY ITS URGENT SO URGENT");
  //else if(val > 100 && val <= 150) say_string("WHERE ARE THOSE HAPPY DAYS THEY SEEM SO HARD TO FIND I TRIED TO REACH FOR YOU BUT YOU HAVE CLOSED YOUR MIND WHATEVER HAPPENED TO OUR LOVE I WISH I UNDERSTOOD IT USED TO BE SO NICE IT USED TO BE SO GOOD  SO WHEN YOURE NEAR ME DARLING CANT YOU HEAR ME S O S THE LOVE YOU GAVE ME NOTHING ELSE CAN SAVE ME S O S WHEN YOURE GONE HOW CAN I EVEN TRY TO GO ON WHEN YOURE GONE THOUGH I TRY HOW CAN I CARRY ON  YOU SEEM SO FAR AWAY THOUGH YOU ARE STANDING NEAR YOU MADE ME FEEL ALIVE BUT SOMETHING DIED I FEAR I REALLY TRIED TO MAKE IT OUT I WISH I UNDERSTOOD WHAT HAPPENED TO OUR LOVE IT USED TO BE SO GOOD  SO WHEN YOURE NEAR ME DARLING CANT YOU HEAR ME S O S THE LOVE YOU GAVE ME NOTHING ELSE CAN SAVE ME S O S WHEN YOURE GONE HOW CAN I EVEN TRY TO GO ON WHEN YOURE GONE THOUGH I TRY HOW CAN I CARRY ON  SO WHEN YOURE NEAR ME DARLING CANT YOU HEAR ME S O S AND THE LOVE YOU GAVE ME NOTHING ELSE CAN SAVE ME S O S WHEN YOURE GONE HOW CAN I EVEN TRY TO GO ON WHEN YOURE GONE THOUGH I TRY HOW CAN I CARRY ON WHEN YOURE GONE HOW CAN I EVEN TRY TO GO ON WHEN YOURE GONE THOUGH I TRY HOW CAN I CARRY ON ")
}



void say_string(char * asciimsg){
  int index = 0;
  char charac;
  charac = asciimsg[index];
  while(charac!='\0' && val > 1015){
    val = analogRead(dial);
    
    Serial.println(charac);
    say_char(charac);
    
    
    //Serial.println(morsecode[(int)charac]);
    charac = asciimsg[++index];
    shortgap();
  }
}
